/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.gui;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.gui.Gui;
import net.jayjay.dangerzone.item.Items;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.texture.Textures;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class GuiIngame
extends Gui {
    private UnicodeFont fontRenderer;
    public int screenWidth = 1280;
    public int screenHeight = 720;

    public GuiIngame() {
        try {
            Font awtFont = Font.createFont(0, DZ2.class.getResourceAsStream("/fonts/font.ttf")).deriveFont(32.0f);
            this.fontRenderer = new UnicodeFont(awtFont);
            this.fontRenderer.addAsciiGlyphs();
            this.fontRenderer.getEffects().add(new ColorEffect(Color.WHITE));
            this.fontRenderer.loadGlyphs();
        }
        catch (IOException e2) {
            System.err.println("Failed to load font.ttf: " + e2.getMessage());
            try {
                Font awtFont = new Font("SansSerif", 0, 32);
                this.fontRenderer = new UnicodeFont(awtFont);
                this.fontRenderer.addAsciiGlyphs();
                this.fontRenderer.getEffects().add(new ColorEffect(Color.WHITE));
                this.fontRenderer.loadGlyphs();
            }
            catch (Exception ex) {
                System.err.println("Failed to load fallback font: " + ex.getMessage());
                this.fontRenderer = null;
            }
        }
        catch (Exception e3) {
            System.err.println("Unexpected error initializing font: " + e3.getMessage());
            this.fontRenderer = null;
        }
    }

    @Override
    public void drawGui(float a2) {
        if (this.fontRenderer == null) {
            System.err.println("Font renderer is null, skipping text rendering");
            return;
        }
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.screenWidth, this.screenHeight, 0.0, 100.0, 300.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -200.0f);
        GL11.glPushMatrix();
        this.drawHotbar();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawFpsCounter();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawVersionText();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawEntityCounter();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.drawCoords();
        GL11.glPopMatrix();
    }

    private void drawHotbar() {
        float hotbarWidth = 728.0f;
        float hotbarHeight = 88.0f;
        float hotbarX = ((float)this.screenWidth - hotbarWidth) / 2.0f;
        float hotbarY = (float)this.screenHeight - hotbarHeight - 40.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef(hotbarX + 100.0f, hotbarY + 112.0f, 0.0f);
        Tesselator tess = Tesselator.INSTANCE;
        GL11.glScalef(64.0f, 64.0f, 64.0f);
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        GL11.glScalef(-1.0f, -1.0f, 1.0f);
        int blockTexId = Textures.loadTexture("/terrain.png", 9728);
        GL11.glBindTexture(3553, blockTexId);
        GL11.glEnable(3553);
        tess.begin(7);
        Blocks.blocks[DZ2.theDangerZone.blockPaintTexture].render(tess, DZ2.theDangerZone.world, 0, -2, 0, 0);
        this.renderBlockHotbar(tess, Blocks.blocks[DZ2.theDangerZone.blockPaintTexture], -2, 0, 0);
        tess.flush();
        GL11.glDisable(3553);
        GL11.glPopMatrix();
        if (this.fontRenderer != null) {
            String blockText = "" + DZ2.theDangerZone.blockPaintTexture;
            GL11.glPushMatrix();
            GL11.glTranslatef(hotbarX + 200.0f, hotbarY + 28.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, blockText, new org.newdawn.slick.Color(0.5f, 0.7f, 1.0f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef(hotbarX + 300.0f, hotbarY + 112.0f, 0.0f);
        GL11.glScalef(64.0f, 64.0f, 64.0f);
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        GL11.glScalef(-1.0f, -1.0f, 1.0f);
        int itemTexId = Textures.loadTexture("/items.png", 9728);
        GL11.glBindTexture(3553, itemTexId);
        GL11.glEnable(3553);
        tess.begin(7);
        if (Items.items[DZ2.theDangerZone.itemPaintTexture] != null) {
            Items.items[DZ2.theDangerZone.itemPaintTexture].render(tess, DZ2.theDangerZone.world, 0, -2, 0, 0);
        }
        tess.flush();
        GL11.glDisable(3553);
        GL11.glPopMatrix();
        if (this.fontRenderer != null) {
            String itemText = "" + DZ2.theDangerZone.itemPaintTexture;
            GL11.glPushMatrix();
            GL11.glTranslatef(hotbarX + 400.0f, hotbarY + 28.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, itemText, new org.newdawn.slick.Color(0.5f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
        if (this.fontRenderer != null) {
            String healthText = "Health: " + DZ2.theDangerZone.thePlayer.health;
            GL11.glPushMatrix();
            GL11.glTranslatef(hotbarX + 520.0f, hotbarY + 28.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, healthText, new org.newdawn.slick.Color(1.0f, 0.3f, 0.3f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawFpsCounter() {
        if (DZ2.theDangerZone.isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "FPS: " + DZ2.theDangerZone.fps + ", " + String.format("%.2f", Float.valueOf(DZ2.theDangerZone.timer.fps));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.screenWidth - this.screenWidth) + 40.0f, 20.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawEntityCounter() {
        if (DZ2.theDangerZone.isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "ENTITIES: " + DZ2.theDangerZone.entityCount;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.screenWidth - this.screenWidth) + 40.0f, 80.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawCoords() {
        if (DZ2.theDangerZone.isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = "null";
            if (DZ2.theDangerZone.thePlayer != null) {
                debugText = "XYZ: " + DZ2.theDangerZone.thePlayer.x + " " + DZ2.theDangerZone.thePlayer.y + " " + DZ2.theDangerZone.thePlayer.z;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.screenWidth - this.screenWidth) + 40.0f, 140.0f, 0.0f);
            GL11.glScalef(2.0f, 2.0f, 2.0f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(1.0f, 1.0f, 0.5f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    private void drawVersionText() {
        if (!DZ2.theDangerZone.isDebugMenu) {
            if (this.fontRenderer == null) {
                return;
            }
            String debugText = DZ2.titleName;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.screenWidth - this.screenWidth) + 40.0f, 20.0f, 0.0f);
            GL11.glScalef(1.5f, 1.5f, 1.5f);
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            GL11.glDisable(3553);
            this.fontRenderer.drawString(0.0f, 0.0f, debugText, new org.newdawn.slick.Color(0.8f, 0.8f, 1.0f));
            GL11.glDisable(3042);
            GL11.glPopMatrix();
        }
    }

    public void renderBlockHotbar(Tesselator tess, Block block, int x, int y, int z) {
        float topBrightness = 1.0f;
        float sideBrightness1 = 0.8f;
        float sideBrightness2 = 0.6f;
        tess.setColor(topBrightness, topBrightness, topBrightness);
        block.renderFace(tess, x, y, z, 0);
        tess.setColor(topBrightness, topBrightness, topBrightness);
        block.renderFace(tess, x, y, z, 1);
        tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
        block.renderFace(tess, x, y, z, 2);
        tess.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
        block.renderFace(tess, x, y, z, 3);
        tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
        block.renderFace(tess, x, y, z, 4);
        tess.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
        block.renderFace(tess, x, y, z, 5);
    }
}

